%% Affichage des signaux acquis par le systme 
% mai 2021
% On suppose que les donnes ont t acquises correctement (en terme de
% nombre d'octets) et en format int32 avec au plus le compteur A
clear all
close all
%% VALEURS A ADAPTER
name = 'test5';
% micros  afficher (numrotation de 0  1023), au moins une valeur
micros_affiches = [0 1 ]; 
% VA  afficher (numrotation de 0  15), le vecteurpeut tre vide
VA_affichees = []; 
nb_aff = 256; % nombre de micros  afficher (acquis ou non)
% Sensibilit des micros
Sens = 3.54; % Pa/digit
%% Lecture de l'en-tte
name_en_tete = strcat(name, ".Mu");
fid = fopen(name_en_tete,'rb');
header.annee = fread(fid,1,'uint16');
header.mois = fread(fid,1,'uint16');
header.jour_semaine = fread(fid,1,'uint16');
header.jour = fread(fid,1,'uint16');
header.heure = fread(fid,1,'uint16');
header.minute = fread(fid,1,'uint16');
header.seconde = fread(fid,1,'uint16');
header.ms = fread(fid,1,'uint16');
header.micros = fread(fid,1024,'uint8');
header.VA = fread(fid,16,'uint8');
header.compteurs = fread(fid,4,'uint8');
header.frequence = fread(fid,1,'single');
header.nb_ech = fread(fid,1,'uint32');
header.duree = fread(fid,1,'single');
header.type = fread(fid,1,'uint8');
header.commentaires = fread(fid,1024,'*char');
fclose(fid);
if (header.type ~= 0)
    disp('Les donnes ne sont pas en format Int32')
    return    
end
%%  Lecture donnes
nb_compteursBCD = sum(header.compteurs(2:4));
nb_VA = sum(header.VA);
nb_micros =  sum(header.micros);
nb_voies = nb_micros + nb_VA + header.compteurs(1);
if (nb_compteursBCD > 0)
    disp('Prsence de compteur(s) B, C, D. Enregistrement  refaire !');
    return
end
if (nb_micros + nb_VA == 0)
    disp('Ni micro, ni voie analogique acquis. Enregistrement  refaire !');
    return
end
if ((micros_affiches(end) >1024)|| (micros_affiches(1) < 0))
    disp('Les micros  afficher sont en dehors des limites. Relancer le programme en corrigeant "micros_affiches" !')
    return
end
if (length(VA_affichees)>0)
    if ((VA_affichees(end) >15)|| (VA_affichees(1) < 0))
        disp('Les VA  afficher sont en dehors des limites. Relancer le programme en corrigeant "VA_affichees" !')
        return
    end
end
nb_ech = header.nb_ech;

disp(header.frequence);
disp(header.nb_ech);
disp(header.duree);
disp(header.type);
disp(header.commentaires);
disp(nb_micros);
disp(nb_voies);

name_dat = strcat(name, '.dat');
fid = fopen(name_dat,'rb');
mat=fread(fid,nb_ech*nb_voies,'*int32');
fclose(fid);
Fe = header.frequence;     % freq echant. en Hz
mat=reshape(mat,nb_voies,[]);
t = (1:nb_ech)/Fe;
%% Affichage puis limination du compteur A
scrsz = get(0,'ScreenSize');    %dtermination de la taille de l'cran
fen_aff = [scrsz(3)/8 scrsz(4)/8 3*scrsz(3)/4 3*scrsz(4)/4];
if (header.compteurs(1) == 1)
    figure('Position',fen_aff,'NumberTitle','off','Name','Compteur','Color','White');
    plot(t,mat(1,:));
    title('Compteur');
    xlabel('temps (s)');
    set(gca,'FontName','Century Gothic','FontSize',12);
    mat = mat(2:end,:);
    nb_voies = nb_voies - 1;
end

%% Correspondance micros/VA et voies
% une valeur  -1 signifie l'absence d'enregistrement
num_mic = zeros(1,1024);
num_VA = zeros(1,16);
k = 0;
for i = 0:3
   for j = 1:256
       if(header.micros(j+256*i) == 1)
          k = k + 1;
          num_mic(i * 256 + j) = k;
       else
          num_mic(i * 256 + j) = -1; 
       end
   end
   for j = 1:4
       if(header.VA(j+4*i) == 1)
          k = k + 1;
          num_VA(j+4*i) = k;
       else
           num_VA(j+4*i) = -1;
       end
   end
end

%% Affichage des micros (temporel et sonagramme)
nfft = 2048;                    % nombre d'chantillons sur lesquels est calcul chaque FFT               
n_window= nfft;                 % condition permettant de mettre une fentre de Hanning
noverlap = ceil(n_window/2);    % nombre d'chantillons qui sont repris dans la fentre suivante
scrsz = get(0,'ScreenSize');    %dtermination de la taille de l'cran
for i=1:length(micros_affiches)
    figure('Position',fen_aff,'NumberTitle','off',...
            'Name','Signaux des micros enregistrs','Color','White');
    if (num_mic(micros_affiches(i)+1) == -1)
        plot(t,zeros(1,nb_ech));
        title(['Micro n ',num2str(micros_affiches(i)),' non enregistr']);
        xlabel('temps (s)');
        set(gca,'FontName','Century Gothic','FontSize',12);
    else
        plot(t,Sens /1000. * mat(num_mic(micros_affiches(i)+1),:));
        title(['Micro n ',num2str(micros_affiches(i))]);
        xlabel('temps (s)');
        ylabel('amplitude (mPa)');
        set(gca,'FontName','Century Gothic','FontSize',12);
        S = spectrogram(single(mat(num_mic(micros_affiches(i)+1),:)),...
            n_window,noverlap,nfft,Fe,'yaxis');   % calcul du sonagramme
        S = 10*log10(abs(S));           % calcul du module en dB
        Smax =max(max(S));
        Smin =min(min(S));
        % affichage du sonagramme
        figure('Position',[scrsz(3)/8 scrsz(4)/8 3*scrsz(3)/4 3*scrsz(4)/4],...
                'NumberTitle','off','Name','Sonagramme','Color','White');
        imagesc([0 t(end)],[0 Fe/2]/1000,S,[Smin Smax]);  
        colormap(jet);
        c = colorbar;
        c.Label.String = 'dB';
        title(['Micro n ',num2str(micros_affiches(i))]);
        xlabel('Temps (s)','FontName','Century Gothic','FontSize',14);
        ylabel('Frquence (kHz)','FontName','Century Gothic','FontSize',14);
        set(gca,'FontName','Century Gothic','FontSize',14);
        axis xy;                % oriente l'axe y de bas en haut
    end
end
%% Affichage des VA
if (length(VA_affichees)>0)
    for i=1:length(VA_affichees)
        figure('Position',fen_aff,'NumberTitle','off',...
                'Name','Signaux des VA enregistres','Color','White');
        if (num_VA(VA_affichees(i)+1) == -1)
            plot(t,zeros(1,nb_ech));
            title(['VA n ',num2str(VA_affichees(i)),' non enregistre']);
            xlabel('temps (s)');
            set(gca,'FontName','Century Gothic','FontSize',12);
        else
            plot(t,mat(num_VA(VA_affichees(i)+1),:));
            title(['VA n ',num2str(VA_affichees(i))]);
            xlabel('temps (s)');
            set(gca,'FontName','Century Gothic','FontSize',12);
            S = spectrogram(single(mat(num_VA(VA_affichees(i)+1),:)),n_window,noverlap,nfft,Fe,'yaxis');   % calcul du sonagramme
            S = 10*log10(abs(S));           % calcul du module en dB
            Smax =max(max(S));
            Smin =min(min(S));
            % affichage du sonagramme
            figure('Position',[scrsz(3)/8 scrsz(4)/8 3*scrsz(3)/4 3*scrsz(4)/4],...
                    'NumberTitle','off','Name','Sonagramme','Color','White');
            imagesc([0 t(end)],[0 Fe/2]/1000,S,[Smin Smax]);  
            colormap(jet);
            c = colorbar;
            c.Label.String = 'dB';
            title(['VA n ',num2str(VA_affichees(i))]);
            xlabel('Temps (s)','FontName','Century Gothic','FontSize',14);          % mise en forme
            ylabel('Frquence (kHz)','FontName','Century Gothic','FontSize',14);
            set(gca,'FontName','Century Gothic','FontSize',14);
            axis xy;                % oriente l'axe y de bas en haut
        end
    end
end
%% Affichage de l'ensemble des micros
mat_mic = zeros(1024,nb_ech);
for i = 1:1024
    if (num_mic(i) >0)
        mat_mic(i,:) = mat(num_mic(i),:);
    end
end
figure('Position',fen_aff,'NumberTitle','off',...
        'Name','Signaux des micros enregistrs','Color','White');
imagesc([0 header.duree],[0 nb_aff-1],mat_mic(1:nb_aff,:)/1000.);
set(gca,'FontName','Century Gothic','FontSize',14);
xlabel('Temps (s)');
ylabel('Micros');
axis xy;
colormap(jet)
c = colorbar;
c.Label.String = 'mPa';